-- Author  : John D P Purba
-- Purpose : Kontrol Register Input

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY FSMInput IS
	PORT(clock_i : IN std_logic;
		 reset_i : IN std_logic;

		 en_i	 : IN std_logic;
		 load_o  : OUT std_logic
	);
END FSMInput;

ARCHITECTURE FSMInput_RTL of FSMInput IS

TYPE state IS (busy, nop);
SIGNAL sig_counter  : INTEGER RANGE 0 TO 5;
SIGNAL sig_kontrol  : state;
SIGNAL sig_load 	: std_logic;

BEGIN

	load_o <= sig_load;		
	
	PROCESS(clock_i,reset_i)
	BEGIN
	
	IF reset_i = '1' THEN
		sig_load <= '0';		
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		CASE sig_kontrol IS 
			WHEN nop =>
				sig_load <= '0';
			WHEN busy =>
				IF sig_counter = 4 THEN
					sig_load <= '1';
				ELSE
					sig_load <= '0';
				END IF;
			END CASE;
	END IF;
	END PROCESS;
	
	PROCESS(clock_i, reset_i)
	BEGIN
	
	IF reset_i = '1' THEN
		sig_counter <= 0;
		sig_kontrol <= nop;
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		IF(en_i = '1' AND sig_counter /= 4) THEN
			sig_counter <= sig_counter + 1;
			sig_kontrol <= busy;
		ELSE
			sig_counter <= 0;
			sig_kontrol <= nop;
		END IF;
	END IF;		
	END PROCESS;

END FSMInput_RTL;

	







